/*
 * Decompiled with CFR 0.152.
 */
package com.midronome.firmwareupdater;

import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.Key;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class FirmwareFileReader {
    private static byte[] sysexBytes;
    private static boolean fileLoaded;
    private static final String ALGORITHM = "AES/CBC/PKCS5Padding";
    private static final byte[] KEY;

    public static byte[] getSysexBytes() {
        return sysexBytes;
    }

    public static String getFirmwareVersion() throws RuntimeException {
        if (!fileLoaded) {
            throw new RuntimeException("The firmware should always be loaded before calling getFirmwareVersion");
        }
        return "Firmware file version: " + Byte.toUnsignedInt(sysexBytes[15]) + "." + Byte.toUnsignedInt(sysexBytes[16]) + "\n";
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean openFirmwareFile(File file) {
        byte[] orgData;
        byte[] iv;
        fileLoaded = false;
        try (DataInputStream dis = new DataInputStream(new FileInputStream(file));){
            int ivLength222 = dis.readInt();
            if (ivLength222 < 0 || ivLength222 > 256) {
                boolean bl = false;
                return bl;
            }
            iv = new byte[ivLength222];
            dis.readFully(iv);
            orgData = dis.readAllBytes();
        }
        catch (IOException e) {
            return false;
        }
        try {
            SecretKeySpec keySpec = new SecretKeySpec(KEY, "AES");
            Cipher cipher = Cipher.getInstance(ALGORITHM);
            IvParameterSpec ivSpec = new IvParameterSpec(iv);
            cipher.init(2, (Key)keySpec, ivSpec);
            sysexBytes = cipher.doFinal(orgData);
        }
        catch (GeneralSecurityException e) {
            return false;
        }
        fileLoaded = true;
        System.out.println("Decrypted data length: " + sysexBytes.length);
        if (sysexBytes[0] != -16) {
            return false;
        }
        if (sysexBytes[sysexBytes.length - 1] == -9) return "FIRMWAREMIDR".equals(new String(sysexBytes, 1, 12));
        return false;
    }

    static {
        fileLoaded = false;
        KEY = new byte[]{80, 101, 83, 104, 86, 109, 89, -87, 113, 51, 116, 54, 119, 57, 122, 36, 67, 38, 70, 41, 72, 64, 77, 90, 99, 81, 102, 84, 106, 87, 110, 114};
    }
}

