/*
 * Decompiled with CFR 0.152.
 */
package com.midronome.firmwareupdater;

import com.midronome.firmwareupdater.FirmwareFileReader;
import com.midronome.firmwareupdater.MidiSysexComm;
import java.io.File;
import java.net.URL;
import java.util.ResourceBundle;
import javafx.application.Application;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.fxml.Initializable;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.stage.FileChooser;
import javafx.stage.Stage;

public class App
extends Application
implements Initializable {
    @FXML
    private Label errorLabel;
    @FXML
    private Label stepText;
    @FXML
    private ImageView stepImage;
    @FXML
    private Button stepButton;
    private MidiSysexComm midiSysexComm;
    private int currentStep;
    private final String[] stepTexts = new String[]{"Keep the TAP TEMPO, PLAY, and MUTE button pressed on your Midronome, while you unplug and re-plug the USB cable.\nWhen it restarts in Bootloader mode (\"btl\"), you can release the buttons.", "The Midronome will show the current Firmware version (\"Cur Fir x.x\"), and you can press MUTE when it is blinking.\n", "Now the Midronome will connect to the computer - it will show \"rdy\" (ready) and a green light when it is connected.", "The Midronome will confirm this (\"UPG to x.x\") and start updating as soon as you press MUTE.", "All done! :) \nYou can now restart your Midronome by pressing MUTE."};
    private final String[] stepButtonTexts = new String[]{"Done, next", "Done, next", "The device shows \"rdy\"", "The device shows \"don\"", "Close this window"};

    public static void main(String[] args) {
        App.launch(args);
    }

    private void switchToNextStep(String extraText) {
        if (this.currentStep >= 4) {
            return;
        }
        ++this.currentStep;
        String stepImgAddr = this.getClass().getResource("step" + this.currentStep + ".gif").toString();
        this.stepImage.setImage(new Image(stepImgAddr));
        this.stepText.setText(extraText + this.stepTexts[this.currentStep]);
        this.errorLabel.setText("");
        this.stepButton.setText(this.stepButtonTexts[this.currentStep]);
    }

    @Override
    public void start(Stage stage) throws Exception {
        FXMLLoader loader = new FXMLLoader(this.getClass().getResource("view.fxml"));
        Parent root = (Parent)loader.load();
        stage.setTitle("Midronome Firmware Updater - v1.0");
        Scene scene = new Scene(root);
        stage.setScene(scene);
        stage.setResizable(false);
        stage.show();
    }

    @Override
    public void initialize(URL url, ResourceBundle resourceBundle) {
        this.currentStep = -1;
        this.switchToNextStep("");
    }

    @FXML
    public void processStep() {
        Stage primaryStage = (Stage)this.stepButton.getScene().getWindow();
        String extraText = "";
        if (this.currentStep == 4) {
            if (this.midiSysexComm.isRunning()) {
                this.midiSysexComm.cancel();
            }
            primaryStage.close();
        }
        if (this.currentStep == 2) {
            this.midiSysexComm = new MidiSysexComm(this.stepButton);
            MidiSysexComm.ConnexionStatus status = this.midiSysexComm.getStatus();
            if (status == MidiSysexComm.ConnexionStatus.NOT_FOUND) {
                this.errorLabel.setText("Error: no Midronome connected to this computer.\nPlease make sure the device is connected to this computer.");
                return;
            }
            if (status == MidiSysexComm.ConnexionStatus.FOUND_IN_NORMAL_MODE) {
                this.errorLabel.setText("Error: the Midronome connected is not in Bootloader mode.\nPlease restart your device holding MUTE, PLAY and TAP TEMPO.");
                return;
            }
            try {
                FileChooser fileChooser = new FileChooser();
                fileChooser.setTitle("Choose Midronome firmware file");
                fileChooser.setSelectedExtensionFilter(new FileChooser.ExtensionFilter("Midronome firmware files", ".midr"));
                File file = fileChooser.showOpenDialog(this.errorLabel.getScene().getWindow());
                if (file == null) {
                    this.errorLabel.setText("Please press the button and load a Midronome firmware file (*.midr).");
                    return;
                }
                if (!FirmwareFileReader.openFirmwareFile(file)) {
                    this.errorLabel.setText("Invalid firmware file. Please load a valid Midronome firmware file (*.midr).");
                    return;
                }
                extraText = FirmwareFileReader.getFirmwareVersion();
            }
            catch (Exception e) {
                e.printStackTrace();
                return;
            }
        }
        this.switchToNextStep(extraText);
        if (this.currentStep == 3) {
            this.midiSysexComm.setSysexData(FirmwareFileReader.getSysexBytes());
            this.stepButton.setDisable(true);
            primaryStage.setOnCloseRequest(event -> {
                if (this.midiSysexComm.isRunning()) {
                    this.midiSysexComm.cancel();
                }
            });
            new Thread(this.midiSysexComm).start();
        }
    }
}

