/*
 * Decompiled with CFR 0.152.
 */
package com.midronome.firmwareupdater;

import javafx.application.Platform;
import javafx.concurrent.Task;
import javafx.scene.control.Button;
import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MidiDevice;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.MidiUnavailableException;
import javax.sound.midi.SysexMessage;
import uk.co.xfactorylibrarians.coremidi4j.CoreMidiDeviceProvider;
import uk.co.xfactorylibrarians.coremidi4j.CoreMidiException;

public class MidiSysexComm
extends Task<Void> {
    private MidiDevice device;
    private byte[] sysexData;
    private final ConnexionStatus status;
    private final Button stepButton;

    public MidiSysexComm(Button stepButton) {
        boolean midroFound;
        block13: {
            this.device = null;
            this.stepButton = stepButton;
            boolean core4JActive = false;
            try {
                if (CoreMidiDeviceProvider.isLibraryLoaded()) {
                    System.out.println("CoreMIDI4J native library is running.");
                    core4JActive = true;
                } else {
                    System.out.println("CoreMIDI4J native library is not available.");
                }
            }
            catch (CoreMidiException e) {
                throw new RuntimeException(e);
            }
            midroFound = false;
            try {
                this.device = null;
                System.out.println("Working MIDI Devices:");
                if (core4JActive) {
                    for (MidiDevice.Info info : CoreMidiDeviceProvider.getMidiDeviceInfo()) {
                        String name = info.toString();
                        System.out.println("Device: " + name + " (vendor: " + info.getVendor() + ")");
                        if (!info.getVendor().equals("Midronome")) continue;
                        midroFound = true;
                        if (!name.contains("CoreMIDI4J") || !name.contains("Firmware update")) continue;
                        MidiDevice d = MidiSystem.getMidiDevice(info);
                        try {
                            d.getReceiver();
                        }
                        catch (MidiUnavailableException ex) {
                            System.out.println("    -> skipped");
                            continue;
                        }
                        System.out.println("    -> chosen.");
                        this.device = d;
                        break block13;
                    }
                    break block13;
                }
                for (MidiDevice.Info info : MidiSystem.getMidiDeviceInfo()) {
                    String name = info.toString();
                    System.out.println("Device: " + name);
                    if (!name.contains("Midronome")) continue;
                    midroFound = true;
                    if (!name.contains("Firmware update")) continue;
                    MidiDevice d = MidiSystem.getMidiDevice(info);
                    try {
                        d.getReceiver();
                    }
                    catch (MidiUnavailableException ex) {
                        System.out.println("    -> skipped");
                        continue;
                    }
                    System.out.println("    -> chosen.");
                    this.device = d;
                    break;
                }
            }
            catch (MidiUnavailableException ex) {
                this.status = ConnexionStatus.NOT_FOUND;
                return;
            }
        }
        this.status = this.device == null ? (midroFound ? ConnexionStatus.FOUND_IN_NORMAL_MODE : ConnexionStatus.NOT_FOUND) : ConnexionStatus.FOUND;
    }

    public ConnexionStatus getStatus() {
        return this.status;
    }

    public void setSysexData(byte[] sysexData) {
        this.sysexData = sysexData;
    }

    @Override
    public Void call() {
        try {
            this.device.open();
            byte[] startBytes = new byte[]{-16};
            byte[] endBytes = new byte[]{-9};
            int chunkSize = 512;
            int numChunks = (this.sysexData.length - 2 + chunkSize - 1) / chunkSize;
            for (int i = 0; i < numChunks; ++i) {
                if (this.isCancelled()) {
                    System.out.println("Firmware data sending cancelled.");
                    this.device.close();
                    Platform.runLater(() -> this.stepButton.setDisable(false));
                    return null;
                }
                int offset = 1 + i * chunkSize;
                int length = Math.min(chunkSize, this.sysexData.length - 1 - offset);
                byte[] chunkData = new byte[length + 2];
                System.arraycopy(startBytes, 0, chunkData, 0, 1);
                System.arraycopy(this.sysexData, offset, chunkData, 1, length);
                System.arraycopy(endBytes, 0, chunkData, length + 1, 1);
                SysexMessage chunk = new SysexMessage(chunkData, chunkData.length);
                this.device.getReceiver().send(chunk, -1L);
            }
            this.device.close();
        }
        catch (InvalidMidiDataException | MidiUnavailableException e) {
            e.printStackTrace();
        }
        Platform.runLater(() -> this.stepButton.setDisable(false));
        return null;
    }

    public static enum ConnexionStatus {
        NOT_FOUND,
        FOUND,
        FOUND_IN_NORMAL_MODE;

    }
}

