/*
 * Decompiled with CFR 0.152.
 */
package com.midronome.midrosyncfilegenerator;

import com.midronome.midrosyncfilegenerator.App;
import java.util.List;
import javafx.event.Event;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.scene.control.TextField;

public class BpmRow {
    private final TextField bpmField;
    private final ComboBox<String> signatureField;
    private final TextField barsField;
    private final Button addButton;
    private final Button removeButton;
    private final App appInstance;

    public BpmRow(BpmRow copy) {
        this(copy.appInstance, copy.bpmField.getText(), (String)copy.signatureField.getValue(), copy.barsField.getText());
    }

    public BpmRow(App appInstance) {
        this(appInstance, "120", "4/4", "8");
    }

    public BpmRow(App appInstance, String bpmVal, String signatureVal, String barsVal) {
        this.appInstance = appInstance;
        this.bpmField = new TextField(bpmVal);
        this.bpmField.setAlignment(Pos.CENTER_RIGHT);
        this.signatureField = new ComboBox();
        this.signatureField.getItems().addAll((String[])new String[]{"1/4", "2/4", "3/4", "4/4", "5/4", "6/4", "7/4", "8/4", "9/4", "10/4", "11/4", "12/4", "13/4", "14/4", "15/4", "16/4"});
        this.signatureField.setValue(signatureVal);
        this.signatureField.setVisibleRowCount(6);
        this.barsField = new TextField(barsVal);
        this.barsField.setAlignment(Pos.CENTER_RIGHT);
        this.addButton = new Button("+");
        this.addButton.setOnAction(appInstance::addRow);
        this.addButton.setOnKeyPressed(appInstance::addRow);
        this.removeButton = new Button("-");
        this.removeButton.setOnAction(appInstance::removeRow);
        this.removeButton.setOnKeyPressed(appInstance::removeRow);
    }

    public void removeButtonSetDisable(boolean dis) {
        this.removeButton.setDisable(dis);
    }

    public static int findRowIndex(List<BpmRow> rows, Event e) {
        Object o = e.getSource();
        for (int i = 0; i < rows.size(); ++i) {
            BpmRow r = rows.get(i);
            if (r.addButton != o && r.removeButton != o) continue;
            return i;
        }
        return -1;
    }

    public Node[] getNodeArray() {
        Node[] ret = new Node[]{this.bpmField, this.signatureField, this.barsField, this.addButton, this.removeButton};
        return ret;
    }

    public int getBpm() {
        int bpm;
        try {
            bpm = Integer.parseInt(this.bpmField.getText());
        }
        catch (NumberFormatException e) {
            bpm = 0;
        }
        return bpm;
    }

    public int getBeatsPerBar() {
        String sig = (String)this.signatureField.getValue();
        return Integer.parseInt(sig.substring(0, sig.indexOf(47)));
    }

    public int getBars() {
        int bars;
        try {
            bars = Integer.parseInt(this.barsField.getText());
        }
        catch (NumberFormatException e) {
            bars = 0;
        }
        return bars;
    }

    public String checkFieldsAndReturnError() {
        int bpm = this.getBpm();
        if (bpm == 0) {
            return "Please enter valid BPMs";
        }
        if (bpm < 30 || bpm > 400) {
            return "All BPMs should be between 30 and 400";
        }
        if (this.getBars() <= 0) {
            return "Please enter valid amounts of bars";
        }
        return null;
    }

    public double getRowLengthInSeconds() {
        return (double)(this.getBeatsPerBar() * this.getBars()) * 60.0 / (double)this.getBpm();
    }
}

