/*
 * Decompiled with CFR 0.152.
 */
package com.midronome.midrosyncfilegenerator;

import com.midronome.midrosyncfilegenerator.BpmRow;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Scanner;

public class PresetHandler {
    private int bitRate;
    private int sampleRate;
    private boolean singleFile;
    private int negDelayInMs;
    private List<BpmRow> gridPaneRows = null;
    private final List<String[]> newRows = new ArrayList<String[]>();
    private FileWriter fileWriter = null;
    private int currentValue = 0;
    private String currentValueStr = "";
    private int lineCounter = 0;
    private String line = "";
    private String errorMsg = "";

    public PresetHandler(int bitRate, int sampleRate, boolean singleFile, int negDelayInMs, List<BpmRow> gridPaneRows) {
        this(bitRate, sampleRate, singleFile, negDelayInMs);
        this.gridPaneRows = gridPaneRows;
    }

    public PresetHandler(int bitRate, int sampleRate, boolean singleFile, int negDelayInMs) {
        this.bitRate = bitRate;
        this.sampleRate = sampleRate;
        this.singleFile = singleFile;
        this.negDelayInMs = negDelayInMs;
    }

    public int getBitRate() {
        return this.bitRate;
    }

    public int getSampleRate() {
        return this.sampleRate;
    }

    public boolean isSingleFile() {
        return this.singleFile;
    }

    public int getNegDelayInMs() {
        return this.negDelayInMs;
    }

    public List<String[]> getNewRows() {
        return this.newRows;
    }

    private void saveBpmRowToFile(BpmRow r) throws IOException {
        String tmpStr = r.getBpm() + " bpm ";
        if (r.getBpm() < 100) {
            tmpStr = tmpStr + " ";
        }
        tmpStr = tmpStr + "; " + r.getBeatsPerBar() + "/4 ";
        if (r.getBeatsPerBar() < 10) {
            tmpStr = tmpStr + " ";
        }
        this.fileWriter.write(tmpStr + "; " + r.getBars() + " bars\r\n");
    }

    public String savePreset(File file) {
        try {
            this.fileWriter = new FileWriter(file);
            this.fileWriter.write("#######################################################################\r\n");
            this.fileWriter.write("#             Midronome Sync File Generator - Preset File             #\r\n");
            this.fileWriter.write("#######################################################################\r\n\r\n\r\n");
            this.fileWriter.write("# ----- FORMAT INFO ----\r\n");
            this.fileWriter.write("#\r\n");
            this.fileWriter.write("# Lines starting with # are ignored\r\n");
            this.fileWriter.write("#\r\n");
            this.fileWriter.write("# For each BPM row:\r\n");
            this.fileWriter.write("#     <X>bpm ; <Y> ; <Z>bars\r\n");
            this.fileWriter.write("#     (with <X> = tempo, <Y> = time signature and <Z> = amount of bars)\r\n");
            this.fileWriter.write("#\r\n");
            this.fileWriter.write("# optional (setting unchanged when not found in preset file):\r\n");
            this.fileWriter.write("#     bitrate    = x (sets the bitrate, 16 or 24)\r\n");
            this.fileWriter.write("#     samplerate = x (sets the sample rate, 44100 or 48000)\r\n");
            this.fileWriter.write("#     multiple   = 0 (sets the \"Single File\" option)\r\n");
            this.fileWriter.write("#     multiple   = 1 (sets the \"Multiple Files\" option)\r\n");
            this.fileWriter.write("#     delay      = x (sets the delay to x ms, from -140 to 0)\r\n\r\n\r\n");
            this.fileWriter.write("bitrate    = " + this.bitRate + "\r\n");
            this.fileWriter.write("samplerate = " + this.sampleRate + "\r\n");
            if (this.singleFile) {
                this.fileWriter.write("multiple   = 0\r\n");
            } else {
                this.fileWriter.write("multiple   = 1\r\n");
            }
            this.fileWriter.write("delay      = " + this.negDelayInMs + "\r\n\r\n");
            for (BpmRow r : this.gridPaneRows) {
                this.saveBpmRowToFile(r);
            }
            this.fileWriter.close();
            this.fileWriter = null;
        }
        catch (IOException e) {
            e.printStackTrace();
            return "Error saving preset: " + e.getMessage();
        }
        return null;
    }

    private boolean readBpmRowFromLine(String line) {
        int val;
        String[] list = line.split(";");
        if (list.length < 3) {
            return false;
        }
        String valStr = list[0].trim();
        if (valStr.endsWith("bpm")) {
            valStr = valStr.substring(0, valStr.length() - 3).trim();
        }
        try {
            val = Integer.parseInt(valStr);
        }
        catch (NumberFormatException e) {
            return false;
        }
        if (val < 0 || val >= 100000) {
            return false;
        }
        list[0] = Integer.toString(val);
        valStr = list[1].trim().split("/")[0];
        try {
            val = Integer.parseInt(valStr);
        }
        catch (NumberFormatException e) {
            return false;
        }
        if (val < 1 || val > 16) {
            return false;
        }
        list[1] = val + "/4";
        valStr = list[2].trim();
        if (valStr.endsWith("bars")) {
            valStr = valStr.substring(0, valStr.length() - 4).trim();
        }
        try {
            val = Integer.parseInt(valStr);
        }
        catch (NumberFormatException e) {
            return false;
        }
        if (val < 0 || val >= 100000) {
            return false;
        }
        list[2] = Integer.toString(val);
        this.newRows.add(list);
        return true;
    }

    private boolean isLineAParam(String paramName) {
        String[] splitLine = this.line.split("=");
        if (splitLine.length < 2) {
            return false;
        }
        if (!splitLine[0].trim().equals(paramName)) {
            return false;
        }
        this.currentValueStr = splitLine[1].trim();
        return true;
    }

    private boolean getValueFromParam(String paramName) {
        try {
            this.currentValue = Integer.parseInt(this.currentValueStr);
        }
        catch (NumberFormatException exc) {
            this.errorMsg = this.lineCounter + ": invalid " + paramName + " ('" + this.currentValueStr + "')";
            return false;
        }
        return true;
    }

    private boolean getValueFromParamCheckValues(String paramName, int val1, int val2) {
        if (!this.getValueFromParam(paramName)) {
            return false;
        }
        if (this.currentValue != val1 && this.currentValue != val2) {
            this.errorMsg = this.lineCounter + ": " + paramName + " can only be " + val1 + " or " + val2;
            return false;
        }
        return true;
    }

    public String loadPreset(File file) {
        this.newRows.clear();
        try {
            Scanner scanner = new Scanner(file);
            this.lineCounter = 0;
            while (scanner.hasNextLine()) {
                ++this.lineCounter;
                this.line = scanner.nextLine().trim();
                if (this.line.isEmpty() || this.line.charAt(0) == '#') continue;
                if (this.isLineAParam("delay")) {
                    if (!this.getValueFromParam("delay")) break;
                    if (this.currentValue > 0) {
                        this.currentValue = -this.currentValue;
                    }
                    if (this.currentValue < -140) {
                        this.errorMsg = this.lineCounter + ": delay must be between -140 and 0";
                        break;
                    }
                    this.negDelayInMs = this.currentValue;
                    continue;
                }
                if (this.isLineAParam("bitrate")) {
                    if (!this.getValueFromParamCheckValues("bitrate", 16, 24)) break;
                    this.bitRate = this.currentValue;
                    continue;
                }
                if (this.isLineAParam("samplerate")) {
                    if (!this.getValueFromParamCheckValues("samplerate", 44100, 48000)) break;
                    this.sampleRate = this.currentValue;
                    continue;
                }
                if (this.isLineAParam("multiple")) {
                    if (!this.getValueFromParamCheckValues("multiple", 0, 1)) break;
                    this.singleFile = this.currentValue == 0;
                    continue;
                }
                if (this.readBpmRowFromLine(this.line)) continue;
                this.errorMsg = this.lineCounter + ", invalid line: " + this.line;
                break;
            }
            scanner.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return "Error while reading preset file: " + e.getMessage();
        }
        if (!this.errorMsg.isEmpty()) {
            return "Error in preset file @line " + this.errorMsg;
        }
        if (this.newRows.isEmpty()) {
            return "Error in preset file: no BPM rows found";
        }
        if (!this.singleFile && this.newRows.size() == 1) {
            this.singleFile = true;
        }
        return null;
    }
}

