/*
 * Decompiled with CFR 0.152.
 */
package com.midronome.midrosyncfilegenerator;

import com.midronome.midrosyncfilegenerator.BpmRow;
import com.midronome.midrosyncfilegenerator.PresetHandler;
import com.midronome.midrosyncfilegenerator.WavFileGenerator;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Set;
import javafx.application.Application;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.concurrent.Task;
import javafx.event.ActionEvent;
import javafx.event.Event;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.Menu;
import javafx.scene.control.MenuBar;
import javafx.scene.control.MenuItem;
import javafx.scene.control.ProgressBar;
import javafx.scene.control.RadioButton;
import javafx.scene.control.RadioMenuItem;
import javafx.scene.control.Slider;
import javafx.scene.control.TextField;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.GridPane;
import javafx.stage.DirectoryChooser;
import javafx.stage.FileChooser;
import javafx.stage.Stage;

public class App
extends Application
implements Initializable {
    @FXML
    public Slider delaySlider;
    @FXML
    public MenuBar menuBar;
    @FXML
    private Label errorLabel;
    @FXML
    private TextField delayField;
    @FXML
    private Button genButton;
    @FXML
    private ProgressBar progressBar;
    @FXML
    private Button cancelButton;
    @FXML
    private GridPane gridPane;
    @FXML
    private RadioButton multipleFilesButton;
    @FXML
    private RadioButton singleFileButton;
    private int sampleRate = 48000;
    private int bitRate = 24;
    private int negDelayInMs;
    private Task<Void> generateWavTask;
    private boolean singleFile = true;
    private final List<BpmRow> gridPaneRows = new ArrayList<BpmRow>();
    private String lastPresetFileNameUsed = "";

    public static void main(String[] args) {
        App.launch(args);
    }

    @Override
    public void start(Stage stage) throws Exception {
        FXMLLoader loader = new FXMLLoader(this.getClass().getResource("view.fxml"));
        Parent root = (Parent)loader.load();
        stage.setTitle("Midronome MidroSync File Generator - v1.0");
        Scene scene = new Scene(root);
        stage.setScene(scene);
        stage.setResizable(false);
        stage.show();
    }

    @Override
    public void initialize(URL url, ResourceBundle resourceBundle) {
        BpmRow row = new BpmRow(this);
        row.removeButtonSetDisable(true);
        this.gridPaneRows.add(row);
        this.updateGridPane();
        this.delaySlider.valueProperty().addListener(new ChangeListener<Number>(){

            @Override
            public void changed(ObservableValue<? extends Number> observableValue, Number oldValue, Number newValue) {
                int delayVal = newValue.intValue();
                App.this.delayField.setText(Integer.toString(delayVal));
            }
        });
        this.delayField.textProperty().addListener(new ChangeListener<String>(){

            @Override
            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                try {
                    int delayVal = Integer.parseInt(newValue);
                    if (delayVal < -140 || delayVal > 0) {
                        return;
                    }
                    App.this.delaySlider.setValue(delayVal);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        });
        Menu fileMenu = (Menu)this.menuBar.getMenus().get(0);
    }

    @FXML
    public void savePreset(Event e) {
        if (!this.checkAllFields()) {
            return;
        }
        Stage primaryStage = (Stage)((MenuItem)e.getSource()).getParentPopup().getOwnerWindow();
        FileChooser fileChooser = new FileChooser();
        fileChooser.setTitle("Save Preset");
        if (this.lastPresetFileNameUsed.isEmpty()) {
            fileChooser.setInitialFileName("preset.txt");
        } else {
            fileChooser.setInitialFileName(this.lastPresetFileNameUsed);
        }
        File file = fileChooser.showSaveDialog(primaryStage);
        if (file == null) {
            return;
        }
        this.lastPresetFileNameUsed = file.getName();
        this.errorLabel.setText("Saving preset...");
        PresetHandler handler = new PresetHandler(this.bitRate, this.sampleRate, this.singleFile, this.negDelayInMs, this.gridPaneRows);
        String err = handler.savePreset(file);
        if (err != null) {
            this.errorLabel.setText(err);
        }
        this.errorLabel.setText("Preset saved successfully to " + file.getName());
    }

    @FXML
    public void loadPreset(Event e) {
        ObservableList<MenuItem> l;
        Stage primaryStage = (Stage)((MenuItem)e.getSource()).getParentPopup().getOwnerWindow();
        FileChooser fileChooser = new FileChooser();
        fileChooser.setTitle("Load Preset");
        File file = fileChooser.showOpenDialog(primaryStage);
        if (file == null) {
            return;
        }
        this.errorLabel.setText("Loading preset...");
        PresetHandler handler = new PresetHandler(this.bitRate, this.sampleRate, this.singleFile, this.negDelayInMs);
        String err = handler.loadPreset(file);
        if (err != null) {
            this.errorLabel.setText(err);
            return;
        }
        if (handler.getBitRate() != this.bitRate) {
            this.bitRate = handler.getBitRate();
            l = ((Menu)this.menuBar.getMenus().get(1)).getItems();
            if (this.bitRate == 16) {
                ((RadioMenuItem)l.get(0)).setSelected(true);
            } else {
                ((RadioMenuItem)l.get(1)).setSelected(true);
            }
        }
        if (handler.getSampleRate() != this.sampleRate) {
            this.sampleRate = handler.getSampleRate();
            l = ((Menu)this.menuBar.getMenus().get(2)).getItems();
            if (this.sampleRate == 44100) {
                ((RadioMenuItem)l.get(0)).setSelected(true);
            } else {
                ((RadioMenuItem)l.get(1)).setSelected(true);
            }
        }
        if (handler.isSingleFile() != this.singleFile) {
            this.singleFile = handler.isSingleFile();
            if (this.singleFile) {
                this.singleFileButton.setSelected(true);
            } else {
                this.multipleFilesButton.setSelected(true);
            }
        }
        if (handler.getNewRows().size() <= 1) {
            this.multipleFilesButton.setDisable(true);
        } else {
            this.multipleFilesButton.setDisable(false);
        }
        if (handler.getNegDelayInMs() != this.negDelayInMs) {
            this.negDelayInMs = handler.getNegDelayInMs();
            this.delayField.setText(Integer.toString(this.negDelayInMs));
            this.delaySlider.setValue(this.negDelayInMs);
        }
        for (BpmRow r : this.gridPaneRows) {
            this.gridPane.getChildren().removeAll((Node[])r.getNodeArray());
        }
        this.gridPaneRows.clear();
        for (String[] rowValues : handler.getNewRows()) {
            this.gridPaneRows.add(new BpmRow(this, rowValues[0], rowValues[1], rowValues[2]));
        }
        this.updateGridPane();
        this.errorLabel.setText("Preset " + file.getName() + " loaded successfully");
    }

    @FXML
    public void selectBitRate(Event e) {
        RadioMenuItem item16bit = (RadioMenuItem)((Menu)e.getSource()).getItems().get(0);
        this.bitRate = item16bit.isSelected() ? 16 : 24;
    }

    @FXML
    public void selectSampleRate(Event e) {
        RadioMenuItem item441kHz = (RadioMenuItem)((Menu)e.getSource()).getItems().get(0);
        this.sampleRate = item441kHz.isSelected() ? 44100 : 48000;
    }

    @FXML
    public void closeApp(Event e) {
        ((Stage)((MenuItem)e.getSource()).getParentPopup().getOwnerWindow()).close();
    }

    public void addRow(Event e) {
        Object ke;
        if (e instanceof KeyEvent && ((KeyEvent)(ke = (KeyEvent)e)).getCode() != KeyCode.ENTER) {
            return;
        }
        for (BpmRow r : this.gridPaneRows) {
            this.gridPane.getChildren().removeAll((Node[])r.getNodeArray());
        }
        if (this.gridPaneRows.size() == 1) {
            this.gridPaneRows.get(0).removeButtonSetDisable(false);
            this.multipleFilesButton.setDisable(false);
        }
        int rowClickedIdx = BpmRow.findRowIndex(this.gridPaneRows, e);
        BpmRow newRow = new BpmRow(this.gridPaneRows.get(rowClickedIdx));
        this.gridPaneRows.add(rowClickedIdx + 1, newRow);
        this.updateGridPane();
    }

    public void removeRow(Event e) {
        Object ke;
        if (e instanceof KeyEvent && ((KeyEvent)(ke = (KeyEvent)e)).getCode() != KeyCode.ENTER) {
            return;
        }
        for (BpmRow r : this.gridPaneRows) {
            this.gridPane.getChildren().removeAll((Node[])r.getNodeArray());
        }
        int rowClickedIdx = BpmRow.findRowIndex(this.gridPaneRows, e);
        this.gridPaneRows.remove(rowClickedIdx);
        if (this.gridPaneRows.size() == 1) {
            this.gridPaneRows.get(0).removeButtonSetDisable(true);
            this.singleFile = true;
            this.singleFileButton.setSelected(true);
            this.multipleFilesButton.setDisable(true);
        }
        this.updateGridPane();
    }

    private void updateGridPane() {
        for (int i = 0; i < this.gridPaneRows.size(); ++i) {
            BpmRow r = this.gridPaneRows.get(i);
            this.gridPane.addRow(i + 1, r.getNodeArray());
        }
    }

    @FXML
    public void handleGenerateButtonClick(Event e) {
        KeyEvent ke;
        if (e instanceof KeyEvent && (ke = (KeyEvent)e).getCode() != KeyCode.ENTER) {
            return;
        }
        if (!this.checkAllFields()) {
            return;
        }
        this.errorLabel.setText("");
        this.generateWav();
    }

    @FXML
    public void cancelGeneration(Event e) {
        KeyEvent ke;
        if (e instanceof KeyEvent && (ke = (KeyEvent)e).getCode() != KeyCode.ENTER && ke.getCode() != KeyCode.ESCAPE) {
            return;
        }
        if (this.generateWavTask != null && this.generateWavTask.isRunning()) {
            this.generateWavTask.cancel();
            Thread.currentThread().interrupt();
        }
        this.progressBar.progressProperty().unbind();
        this.progressBar.setProgress(0.0);
        this.cancelButton.setVisible(false);
        this.genButton.setDisable(false);
    }

    private boolean checkAllFields() {
        Object[] duplicateRows;
        double totalLength = 0.0;
        for (BpmRow r : this.gridPaneRows) {
            String error = r.checkFieldsAndReturnError();
            if (error != null) {
                this.errorLabel.setText(error);
                return false;
            }
            double curRowLen = r.getRowLengthInSeconds();
            if (this.singleFile) {
                totalLength += curRowLen;
                continue;
            }
            totalLength = Math.max(totalLength, curRowLen);
        }
        if (totalLength > 7200.0) {
            if (this.singleFile) {
                this.errorLabel.setText("The file has too many bars, please stay under 2 hours");
            } else {
                this.errorLabel.setText("Some rows have too many bars, max 2 hours per row");
            }
            return false;
        }
        try {
            this.negDelayInMs = Integer.parseInt(this.delayField.getText());
        }
        catch (NumberFormatException e) {
            this.errorLabel.setText("Please enter a valid negative delay");
            return false;
        }
        if (this.negDelayInMs < -140) {
            this.errorLabel.setText("Minimum negative delay is -140 ms");
            return false;
        }
        if (this.negDelayInMs > 0) {
            this.errorLabel.setText("Maximum negative delay is 0 ms");
            return false;
        }
        if (!this.singleFile && (duplicateRows = this.checkDuplicateRows().toArray()).length != 0) {
            Object errorMessage = "Duplicate values found in rows ";
            for (int i = 0; i < duplicateRows.length; ++i) {
                errorMessage = (String)errorMessage + duplicateRows[i].toString();
                if (i < duplicateRows.length - 2) {
                    errorMessage = (String)errorMessage + ", ";
                    continue;
                }
                if (i != duplicateRows.length - 2) continue;
                errorMessage = (String)errorMessage + " and ";
            }
            this.errorLabel.setText((String)errorMessage);
            return false;
        }
        return true;
    }

    private String generateFileName(BpmRow row) {
        String fileName = row.getBpm() + "bpm_" + row.getBeatsPerBar() + "-4_" + row.getBars() + "bars.wav";
        return fileName;
    }

    private void generateWav() {
        Stage primaryStage = (Stage)this.errorLabel.getScene().getWindow();
        if (this.singleFile) {
            FileChooser fileChooser = new FileChooser();
            fileChooser.setTitle("Save Sync file");
            fileChooser.setInitialFileName(this.generateFileName(this.gridPaneRows.get(0)));
            FileChooser.ExtensionFilter extFilter = new FileChooser.ExtensionFilter("WAV Files", "*.wav");
            fileChooser.getExtensionFilters().add(extFilter);
            fileChooser.setSelectedExtensionFilter(extFilter);
            File file = fileChooser.showSaveDialog(primaryStage);
            if (file == null) {
                return;
            }
            this.genButton.setDisable(true);
            this.cancelButton.setVisible(true);
            this.generateWavTask = new WavFileGenerator(this.gridPaneRows, this.sampleRate, this.bitRate, this.negDelayInMs, file, this.errorLabel, this.genButton, this.cancelButton);
            this.progressBar.progressProperty().bind(this.generateWavTask.progressProperty());
            primaryStage.setOnCloseRequest(event -> {
                if (this.generateWavTask.isRunning()) {
                    this.generateWavTask.cancel();
                }
            });
            this.generateWavTask.setOnSucceeded(event -> this.errorLabel.setText("File " + ((WavFileGenerator)this.generateWavTask).getFileName() + " generated successfully"));
            new Thread(this.generateWavTask).start();
        } else {
            DirectoryChooser dirChooser = new DirectoryChooser();
            dirChooser.setTitle("Select directory");
            File directory = dirChooser.showDialog(primaryStage);
            if (directory == null) {
                return;
            }
            this.generateNextWavFile(0, directory);
        }
    }

    private void generateNextWavFile(int currentIndex, File directory) {
        if (currentIndex >= this.gridPaneRows.size()) {
            this.errorLabel.setText(currentIndex + " files generated successfully");
            return;
        }
        BpmRow curRow = this.gridPaneRows.get(currentIndex);
        File file = new File(directory, this.generateFileName(curRow));
        this.genButton.setDisable(true);
        this.cancelButton.setVisible(true);
        this.generateWavTask = new WavFileGenerator(Collections.singletonList(curRow), this.sampleRate, this.bitRate, this.negDelayInMs, file, this.errorLabel, this.genButton, this.cancelButton);
        this.progressBar.progressProperty().bind(this.generateWavTask.progressProperty());
        Stage primaryStage = (Stage)this.errorLabel.getScene().getWindow();
        primaryStage.setOnCloseRequest(event -> {
            if (this.generateWavTask.isRunning()) {
                this.generateWavTask.cancel();
            }
        });
        this.generateWavTask.setOnSucceeded(event -> this.generateNextWavFile(currentIndex + 1, directory));
        new Thread(this.generateWavTask).start();
    }

    public void handleSingleFileButtonClick(ActionEvent actionEvent) {
        this.singleFile = true;
        this.errorLabel.setText("");
    }

    public void handleMultFileButtonClick(ActionEvent actionEvent) {
        this.singleFile = false;
        this.errorLabel.setText("Please note that files will be overwritten without warning");
    }

    private Set<Integer> checkDuplicateRows() {
        HashSet<Integer> duplicateRows = new HashSet<Integer>();
        for (int i = 0; i < this.gridPaneRows.size(); ++i) {
            BpmRow row1 = this.gridPaneRows.get(i);
            for (int j = i + 1; j < this.gridPaneRows.size(); ++j) {
                BpmRow row2 = this.gridPaneRows.get(j);
                if (!this.areRowsEqual(row1, row2)) continue;
                duplicateRows.add(i + 1);
                duplicateRows.add(j + 1);
            }
        }
        return duplicateRows;
    }

    private boolean areRowsEqual(BpmRow row1, BpmRow row2) {
        return row1.getBpm() == row2.getBpm() && row1.getBeatsPerBar() == row2.getBeatsPerBar() && row1.getBars() == row2.getBars();
    }
}

